/*
 *  TransferMoneySource.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#ifndef _TRANSFERFUNDS_H
#define _TRANSFERFUNDS_H

#include "Currency.h"
#include "MoneySource.h"
#include "MoneySink.h"
#include "Creditor.h"
#include "MyExceptions.h"
#include "Globals.h"
#include "PayBillsContext.h"
#include "TransferMoneyContext.h"
#include <string>
#include <list>

#define SELF static_cast<const ConcreteDerived*>(this)

#define RECIPIENT (((dynamic_cast<TransferMoneyContext*>(Context::currentContext_)?	\
			dynamic_cast<TransferMoneyContext*>(Context::currentContext_):	\
			(throw("dynamic cast failed"), static_cast<TransferMoneyContext*>(NULL))	\
			)->destinationAccount()))


// #define RECIPIENT ((static_cast<TransferMoneyContext*>(Context::currentContext_)->destinationAccount()))
#define CREDITORS ((static_cast<PayBillsContext*>(Context::currentContext_)->creditors()))


using namespace std;

template <class ConcreteDerived>
class TransferMoneySource: public MoneySource
{

public:
	// Role behaviors
	void payBills(void) {
		// While object contexts are changing, we don't want to
		// have an open iterator on an external object. Make a
		// local copy.
		std::list<Creditor*> creditors = CREDITORS;
		std::list<Creditor*>::iterator iter = creditors.begin();
		for (; iter != creditors.end(); iter++ ) {
			try {
				// Note that here we invoke another Use Case
				TransferMoneyContext transferTheFunds((*iter)->amountOwed(),
																SELF,
																(*iter)->account());
				transferTheFunds.doit();
			} catch (InsufficientFunds) {
				throw;
			}
		}
	}

	void transferTo(Currency amount) {
		// This code is reviewable and
		// meaningfully testable with stubs!
		beginTransaction();
		if (SELF->availableBalance() < amount) {
			endTransaction();
			throw InsufficientFunds();
		} else {
			SELF->decreaseBalance(amount);
			RECIPIENT->increaseBalance(amount);
			SELF->updateLog("Transfer Out", DateTime(), amount);
			RECIPIENT->updateLog("Transfer In", DateTime(), amount);
		}
		// gui->displayScreen(SUCCESS_DEPOSIT_SCREEN);
		endTransaction();
	}
public:
	TransferMoneySource(void)  { }
};




template <class ConcreteDerived>
class TransferMoneySink: public MoneySink
{
public:
	void transferFrom(Currency amount) {
		SELF->increaseBalance(amount);
		SELF->updateLog("Transfer in", DateTime(), amount);
	}

public:
	TransferMoneySink(void) {
	}

};



#endif