/*
 *  SavingsAccount.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#ifndef _SAVINGSACCOUNT_H
#define _SAVINGSACCOUNT_H

#include "Account.h"
#include "TransferMoneySource.h"
#include "MyTime.h"
#include <string>

using namespace std;

class XferMoneyContext;
class PayBillsContext;

class SavingsAccount:
		public Account,
		public TransferMoneySink<SavingsAccount> {
friend class TransferMoneySink<SavingsAccount>;	// optional
public:
	SavingsAccount(void);
private:
	// These functions can be virtual if there are
	// specializations of SavingsAccount
	Currency availableBalance(void);
	void decreaseBalance(Currency);
	void increaseBalance(Currency);
	void updateLog(string, MyTime, Currency);
private:
	Currency availableBalance_;
};

#endif