/*
 *  TransferFundsExample.cpp
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#include "SavingsAccount.h"
#include "PayBillsContext.h"
#include "TransferMoneyContext.h"
#include <iostream>

SavingsAccount::SavingsAccount(void):
	availableBalance_(Euro(0.00))
{
	assert(this != NULL);
	
	// no application code
	
	assert(availableBalance_ == Euro(0.0));
	assert(true);
}

Currency SavingsAccount::availableBalance(void) {
	assert(this != NULL);
	std::cout << "SavingsAccount::availableBalance returns "
		<< availableBalance_ << std::endl;
	assert(true);
	return availableBalance_;
}

void SavingsAccount::decreaseBalance(Currency c) {
	assert(this != NULL);
	std::cout << "SavingsAccount::decreaseBalance(" << c << ")" << std::endl;
	assert(c > availableBalance_);
	availableBalance_ -= c;
	assert(availableBalance_ > Euro(0.0));
}

const unsigned MAX_BUFFER_SIZE = 256;

void SavingsAccount::updateLog(string logMessage,
								MyTime timeOfTransaction,
								Currency amountForTransaction) {
	assert(this != NULL);
	assert(logMessage.size() > 0);
	assert(logMessage.size() < MAX_BUFFER_SIZE);
	assert(timeOfTransaction > MyTime("00:00:00.00 1970/1/1"));
	std::cout << "account: " << accountID() << " SavingsAccount::updateLog(\"" << logMessage << "\", MyTime, " << amountForTransaction << ")"
		<< std::endl;
	assert(true);
}

void SavingsAccount::increaseBalance(Currency c) {
	assert(this != NULL);
	std::cout << "SavingsAccount::increaseBalance(" << c << ")" << std::endl;
	availableBalance_ += c;
	assert(true);
}
