/*
 *  PayBillsContext.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/13/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */
 
 
#ifndef _PAYBILLSCONTEXT_H
#define _PAYBILLSCONTEXT_H

#include "Account.h"
#include "Currency.h"
#include "Context.h"
#include <list>

class MoneySource;
class Creditor;

class PayBillsContext: public Context
{
public:
	PayBillsContext(void);
	void doit(void);
	MoneySource *sourceAccount(void) const;
	std::list<Creditor*> creditors(void) const;
private:
	void lookupBindings(void);
	MoneySource *sourceAccount_;
	std::list<Creditor *> creditors_;
};
 
 
 
#endif

