/*
 *  PayBillsContext.cpp
 *  AgileBook
 *
 *  Created by James Coplien on 9/17/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#include "PayBillsContext.h"
#include "MoneySource.h"
#include "MoneySink.h"
#include "InvestmentAccount.h"
#include "SavingsAccount.h"
#include "Creditor.h"


PayBillsContext::PayBillsContext(void): Context()
{
	lookupBindings();
}

void
PayBillsContext::doit(void)
{
	sourceAccount()->payBills();
}

void
PayBillsContext::lookupBindings(void)
{
	// These are somewhat arbitrary and for illustrative
	// purposes. The simulate a database lookup
	InvestmentAccount *investmentAccount = new InvestmentAccount;
	investmentAccount->increaseBalance(Euro(100.00));	// prime it with some money
	sourceAccount_ = investmentAccount;

	creditors_.push_back(new ElectricCompany);
	creditors_.push_back(new GasCompany);
}

MoneySource*
PayBillsContext::sourceAccount(void) const
{
	return sourceAccount_;
}

std::list<Creditor*>
PayBillsContext::creditors(void) const
{
	return creditors_;
}
