/*
 *  InvestmentAccount.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#ifndef _INVESTMENTACCOUNT_H
#define _INVESTMENTACCOUNT_H

#include "Account.h"
#include "Currency.h"
#include "TransferMoneySource.h"
#include "MyTime.h"
#include <string>

using namespace std;

class XferMoneyContext;
class PayBillsContext;

class InvestmentAccount:
	public Account,
	public TransferMoneySource<InvestmentAccount> {
public:
friend class TransferMoneySource<InvestmentAccount>;
	InvestmentAccount(void);
	Currency availableBalance(void);
	void increaseBalance(Currency);
	void decreaseBalance(Currency);
	void updateLog(string, MyTime, Currency);
private:
	Currency availableBalance_;
};

#endif