/*
 *  InvestmentAccount.cpp
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */


#include "InvestmentAccount.h"
#include "PayBillsContext.h"
#include "TransferMoneyContext.h"
#include <string>
#include <iostream>
using namespace std;

InvestmentAccount::InvestmentAccount(void):
	availableBalance_(Euro(0.00))
{
}

Currency InvestmentAccount::availableBalance(void) {
	std::cout << "InvestmentAccount::availableBalance returns "
		<< availableBalance_ << std::endl;
	return availableBalance_;
}


void
InvestmentAccount::increaseBalance(Currency c) {
	std::cout << "InvestmentAccount::increaseBalance(" << c << ")" << std::endl;
	availableBalance_ += c;
}

void
InvestmentAccount::decreaseBalance(Currency c) {
	std::cout << "InvestmentAccount::decreaseBalance(" << c << ")" << std::endl;
	availableBalance_ -= c;
}


void
InvestmentAccount::updateLog(string s, MyTime, Currency c) {
	std::cout << "account: " << accountID() << " InvestmentAccount::updateLog(\"" <<  s << "\", Time, " << c << ")" << std::endl;
}