/*
 *  Creditor.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/17/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#ifndef _CREDITOR_H
#define _CREDITOR_H

#include "Currency.h"

class MoneySink;

class Creditor
{
public:
	virtual MoneySink *account(void) const = 0;
	virtual Currency amountOwed(void) const = 0;
};

class ElectricCompany: public Creditor
{
public:
	ElectricCompany(void);
	MoneySink *account(void) const;
	Currency amountOwed(void) const;
private:
	MoneySink *account_;
};

class GasCompany: public Creditor
{
public:
	GasCompany(void);
	MoneySink *account(void) const;
	Currency amountOwed(void) const;
private:
	MoneySink *account_;
};

#endif