/*
 *  CheckingAccount.h
 *  AgileBook
 *
 *  Created by James Coplien on 9/17/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */


#ifndef _CHECKINGACCOUNT_H
#define _CHECKINGACCOUNT_H

#include "Account.h"
#include "Currency.h"
#include "TransferMoneySource.h"
#include "MyTime.h"
#include <string>

using namespace std;

class XferMoneyContext;
class PayBillsContext;

class CheckingAccount:
		public Account,
		public TransferMoneySink<CheckingAccount> {
public:
	CheckingAccount(void);
private:
	// These functions can be virtual if there are
	// specializations of CheckingAccount
	Currency availableBalance(void);
	void decreaseBalance(Currency);
	void increaseBalance(Currency);
	void updateLog(string, MyTime, Currency);
private:
	Currency availableBalance_;
};

#endif