/*
 *  TransferFundsExample.cpp
 *  AgileBook
 *
 *  Created by James Coplien on 9/2/08.
 *  Copyright 2008 Gertrud & Cope. All rights reserved.
 *
 */

#include "CheckingAccount.h"
#include "PayBillsContext.h"
#include "TransferMoneyContext.h"
#include <iostream>

CheckingAccount::CheckingAccount(void):
	availableBalance_(Euro(100.00))
{
}
	

Currency CheckingAccount::availableBalance(void) {
	std::cout << "CheckingAccount::availableBalance returns "
		<< availableBalance_ << std::endl;
	return availableBalance_;
}

void CheckingAccount::decreaseBalance(Currency c) {
	std::cout << "CheckingAccount::decreaseBalance(" << c << ")" << std::endl;
	availableBalance_ -= c;
}

void CheckingAccount::updateLog(string message, MyTime t, Currency c) {
	std::cout << "account: " << accountID() << " CheckingAccount::updateLog(\"" << message << "\", MyTime, " << c << ")"
		<< std::endl;
}

void CheckingAccount::increaseBalance(Currency c) {
	std::cout << "CheckingAccount::increaseBalance(" << c << ")" << std::endl;
	availableBalance_ += c;
}